package it.unicam.pizzeria4;

import java.sql.SQLException;
import java.util.Scanner;

import it.unicam.pizzeria4.servizio.Menu;
import it.unicam.pizzeria4.sala.Sala;
import it.unicam.pizzeria4.services.DBManager;
import it.unicam.pizzeria4.view.InteractionManager;

import it.unicam.pizzeria4.servizio.Bibita;

public class Pizzeria4 {

	//Queste informazioni andrebbero specificate all'interno di un file di configurazione iniziale.
	static String nome = "Bella Napoli";
	static String indirizzo = "Via Milano, 1 - 00100 Roma";
	static Sala sala;
	static Menu menu;

	public static void main(String[] args) {
		Scanner reader = new Scanner(System.in);
		setPizzeria(reader);
		
		//Viene avviata l'applicazione che permette interazione da linea di comando
		InteractionManager IM = new InteractionManager();
		IM.startPizzeria(reader);
	}

	//Il metodo sottostante è relativo ad un caso d'uso non descritto che si riferisce alla procedura di avvio del sistema
	//Viene riportato in relazione alla configurazione iniziale per la gestione della persistenza
	public static void setPizzeria(Scanner reader) {
		System.out.println("[INFO]: Avvio il sistema Pizzeria 4.0 ...");

		DBManager dbManager = DBManager.getInstance();
		dbManager.setDBManager("jdbc:postgresql://localhost:5432/mescal", "postgres", "prova");
		dbManager.DBtest();

		// La scelta su chi effettua la costruzione degli oggetti tavolo è stata fatta al 
		// fine di ridurre la conoscenza dei dettagli del package Sala all'esterno
		
		sala = Sala.getInstance();
		sala.setSala(dbManager.getTavoli()); 

		menu = Menu.getInstance();
		try {
			menu.setMenu(dbManager.setMenu("menu-1"));
		} catch (SQLException e) {
			e.printStackTrace();
		}
		
		Bibita bibita1 = new Bibita("b1", "Acqua", 20, false, "xyz", "ijk");
		bibita1.setPrezzo(4);
		Bibita bibita2 = new Bibita("b2", "Vino", 10, true, "xyz", "ijk");
		bibita2.setPrezzo(4);
		Bibita bibita3 = new Bibita("b3", "Birra", 20, true, "xyz", "ijk");
		bibita3.setPrezzo(3);
		
		menu.addBibita(bibita1);
		menu.addBibita(bibita2);
		menu.addBibita(bibita3);
	}

}
